// clang++ -c ddf.cpp dts.cpp -Wno-empty-body
#include <iostream>
#include <iomanip>
#include <fstream>
#include <sstream>
#include <cstring>
#include "ddf.h"
using namespace std;
//---------------------------------------------------------------------------
using namespace DT;
/*
istream& operator >> (istream& ist, date& dt)
{string sdt;
 while (ist && ist.peek()!='}') sdt+=ist.get();
 if (!dt.set(sdt)) ist.clear (ios_base::badbit);
 return ist;
}
ostream& operator << (ostream& ost, const date& dt)
{ost<<dt.getstr(6);
 return ost;
}
istream& operator >> (istream& ist, DT::time& tm)
{string sdt;
 while (ist && ist.peek()!='}') sdt+=ist.get();
 if (!tm.set(sdt)) ist.clear (ios_base::badbit);
 return ist;
}
ostream& operator << (ostream& ost, const DT::time& tm)
{ost<<tm.get();
 return ost;
}
*/
//---------------------------------------------------------------------------
class wrstr
{public:
 wrstr (const string& s) : s(s) {}
 const string& s;
 private:
};
//---------------------------------------------------------------------------

istream& operator >> (istream& ist, basic_val& v);
ostream& operator << (ostream& ost, const wrstr& w);
//---------------------------------------------------------------------------

istream& operator >> (istream& ist, basic_val& v)
{v.set (ist,ddf::rpar);
 return ist;
}

ostream& operator << (ostream& ost, const wrstr& w)
{const int l=int(w.s.size());
 for (int i=0; i<l; ++i) {ost<<w.s[i]; if (w.s[i]=='}')ost<<w.s[i];}
 return ost;
}
//---------------------------------------------------------------------------
const char* chan::cod[chan::lcod]={"u2","u3","u4","f4","txt"};
const int chan::lSize[]={2,3,4,4};
const double chan::rBase[]={32767.,8388607.,2147483647.,0.};
const double chan::wBase[]={32767.5,8388607.5,2147483647.5,0.};
const uint chan::tValid[]={65535U,16777215U,4294967295U};
const ios_base::openmode chan::opm[lopm]={ios_base::in|ios_base::binary,
                           ios_base::in|ios_base::out|ios_base::binary,
                           ios_base::in|ios_base::out|ios_base::trunc|ios_base::binary};
//---------------------------------------------------------------------------
//                 powielamy kanal z nowa nazwa zbioru i ew. numerem kanalu (ident)
chan::chan (const string& ddf_file, const chan& ichan, const int openmode, const int i)
          : openmode(openmode)
{read_pos=0; write_pos=0;
// lu=ichan.lu; l=ichan.l;
 lu=0; l=0;
 delay=ichan.delay;
 scale=ichan.scale; sens=ichan.sens; base=ichan.base; rot=ichan.rot;
 name=ichan.name; unit=ichan.unit; comment=ichan.comment;
 ident=(i<0?ichan.ident:i);
 code=ichan.code;
 ostringstream ost; ost<<'.'<<ident;
 file=ddf_file; file+=ost.str();
 status=-err_chan_file_not_opened_yet;
}
chan::chan (const string& ddf_file, const int k, const int cd, const int u,
            const int openmode) : openmode(openmode)
{init ();
 lu=u;
 ident=k;
 code=cd;
 ostringstream ost; ost<<'.'<<ident;
 file=ddf_file; file+=ost.str();
 status=-err_chan_file_not_opened_yet;
}
void chan::init ()
{lu=0; l=0; read_pos=0; write_pos=0;
 delay=0;
 scale=1.; sens=1.; base=0.; rot=0.;
 name=""; unit=""; comment="";
 status=err_part_init;       // trzy ponizsze pozycje sa konieczne, zeby
                             // kanal mozna bylo uzywac
 ident=-1;
 code=-1;
 file="";
}
// usuwamy wsystkie dane z dysku
int chan::errase (const int u)
{if (openmode==0) status=err_channel_readonly;
 else
 {lu=u; l=0; read_pos=0; write_pos=0;
  dat.close (); dat.clear ();   // probujemy go utworzyc o dlugosci zero
  openmode=2; dat.open (file.c_str(),opm[openmode]);
  status=(!dat?err_chan_open:err_ok);
 }
 return status;
}
int chan::open ()
{if (status==-err_chan_file_not_opened_yet)
 {dat.open (file.c_str(),opm[openmode]);
  if (!dat && openmode==1)       // stary zbior, ktory nie istnieje bo mial by dlugosc 0
  {dat.close (); dat.clear ();   // probujemy go utworzyc o dlugosci zero
//   dat.open (file.c_str(),opm[2]);
   openmode=2; dat.open (file.c_str(),opm[openmode]);
  }
  status=(!dat?err_chan_open:err_ok);
//cout<<"chan : open : "<<file<<' '<<status<<'\n';
  if (status==err_chan_open) dat.clear (); else read_pos=write_pos=0;
 }else status=err_chan_reopen;
//cout<<"chan : open : "<<file<<'\n';
 return status;
}
//int chan::open (const int openmode)
//{if (status==-err_chan_file_not_opened_yet)
// {dat.open (file.c_str(),openmode);
//  status=(!dat?err_chan_open:err_ok);
//cout<<"chan : open : "<<file<<' '<<status<<'\n';
//  if (status==err_chan_open) dat.clear (); else read_pos=write_pos=0;
// }else status=err_chan_reopen;
//cout<<"chan : open : "<<file<<'\n';
// return status;
//}
//int chan::openr ()
//{if (status==-err_chan_file_not_opened_yet)
// {dat.open (file.c_str(),ios_base::in|ios_base::binary);
//  status=(!dat?err_chan_open:err_ok);
//cout<<"chan : open : "<<file<<' '<<status<<'\n';
//  if (status==err_chan_open) dat.clear (); else read_pos=write_pos=0;
// }else status=err_chan_reopen;
//cout<<"chan : open : "<<file<<'\n';
// return status;
//}
////                       zeby moc otworzyc nieistniejacy zbior do czytania
////                       i pisania najpierw musimy go otworzyc tylko do pisania
////                       przez co go utworzymy
//int chan::openrw ()
//{if (status==-err_chan_file_not_opened_yet)
// {dat.open (file.c_str(),ios_base::out|ios_base::binary); // ewentualnie tworzymy
//  if (!!dat)
//  {dat.close ();
//   dat.open (file.c_str(),ios_base::in|ios_base::out|ios_base::binary);
//   dat.seekp (0); dat.seekg (0);
//  }
//  status=(!dat?err_chan_open:err_ok);
//cout<<"chan : open : "<<file<<' '<<status<<'\n';
//  if (status==err_chan_open) dat.clear (); else read_pos=write_pos=0;
// }else status=err_chan_reopen;
//cout<<"chan : open : "<<file<<'\n';
// return status;
//}
                        // piszemy od rw_pos, jesli zbior nie byl
                        // jeszcze otwarty to otwieramy do czytania i pisania
                        // rw_pos>=lu i moze przekroczyc zakres danych w zbiorze
                        // jesli rw_pos<lu to poczatkowej czesci danych
                        // nie wypisujemy bo nie ma gdzie, nie jest to blad fatalny
                        // jesli rw_pos poza koncem to wczesniej dopisujemy
                        // wartosci niezdefiniowane
                        // pozycja w zbiorze jest okreslona przez read_pos-lu
int chan::rewrite (const int n, const Real* const x, const int rw_pos)
{//if (status==-err_chan_file_not_opened_yet) open (ios_base::in|ios_base::out|ios_base::binary);
//cerr<<"\nrewrite (n, rw_pos) : "<<n<<' '<<rw_pos;
 bool erw=false;
 if (status<=0)          // mozemy czytac
 {write_pos=rw_pos;
  int m=n;
  const int ma=min(lu-write_pos,m);
  if (ma>0)                          // sa brakujace dane na poczatku
  {write_pos+=ma; m-=ma; erw=true;    // pisanie przed poczatkiem
  }
//cerr<<"\nrewrite (write_pos, ma, lu, l) : "<<write_pos<<' '<<ma<<' '<<lu<<' '<<l;
  if (m>0)                           // jest cos do pisania
  {if (status==-err_chan_file_not_opened_yet) {int wp=write_pos; open (); write_pos=wp;}
//   const int mb=lu+l-write_pos;      // wartosci niezdefiniowane
   const int mb=write_pos-(lu+l);    // wartosci niezdefiniowane
//cerr<<"\nrewrite (write_pos, mb, lu, l) : "<<write_pos<<' '<<mb<<' '<<lu<<' '<<l;
   if (mb>0)                         // uzupelniamy wartosciami niezdefiniowanymi
   {write_pos-=mb;
    if (status<=0) wri (mb);         // wypisujemy undef
    write_pos+=mb;
   }
   if (status<=0) wri (m,x);
   write_pos+=m; if (write_pos-lu>l) l=write_pos-lu;
  }
 }
 if (erw && status==err_ok) status=-err_chan_rewrite_begin;
 return status;
}
                                    // piszemy na zbior od write_pos undef
void chan::wri (const int n)
{if (code>=0 && code<code_last)
 {const int size=lSize[code];
  dat.seekp ((write_pos-lu)*size);  // pozycja w zbiorze, powinna byc >=0
  union {uint u; Real4 r4; char c;};
  if (code<code_f4) u=undef<uint>(); else r4=undef<Real4>();
   for (int i=0; !!dat && i<n; ++i) dat.write (&c,size);
  status=(!dat?err_chan_write:err_ok);
 }else status=err_chan_code;
}
int chan::init (istream& inp, const string& path)
{init ();
 string scode,sfile;
 val<int> val_lu(lu,"offset"),val_l(l,"length"),val_ident(ident,"channel");
 val<string> val_file(sfile,"file"),val_name(name,"name"),val_unit(unit,"unit"),
             val_comment(comment,"comment*"),val_code(scode,"code");
 val<Real> val_scale(scale,"scale"),val_sens(sens,"sensitivity"),
           val_base(base,"base"),val_rot(rot,"rotation");
 val<DT::time> val_delay(delay,"delay");
 basic_val* tv[]={&val_lu,&val_l,&val_ident,&val_file,&val_name,&val_unit,
                  &val_comment,&val_code,&val_scale,&val_sens,&val_base,&val_rot,
                  &val_delay};
 const int ltv=sizeof(tv)/sizeof(tv[0]);
 int r=ddf::rdkey (ltv,tv,inp);
 status=err_chan_reading_channel;
 if (r==0)   // kanal wczytany
 {int i; for (i=0; i<lcod && scode.compare(cod[i])!=0; ++i) {}
  if (i>=lcod) {r=-5; status=err_chan_reading_code;}
  else
  {file=path; file+=sfile; code=i;          // uwzgledniamy sciezke
   status=-err_chan_file_not_opened_yet;    // sprawdzic czy wszystko wczytane
//cout<<file<<'\n';
  }
 }
 return r;
}
//---------------------------------------------------------------------------
string iddf::ddf_type_id[2]={"#ddfTXT0","#ddfBZ20"};
const char* const iddf::ext=".ddf";
void iddf::ddffile (const string& ddf_file)
{const int lext=int(strlen(ext));
 const int i=int(ddf_file.size())-lext; int j=-1;
 if (i>0) for (j=0; j<lext && tolower(ddf_file[i+j])==ext[j]; ++j) ;
 if (j==lext) file=ddf_file.substr(0,i); else file=ddf_file; // bez rozszerzenia
}
//                 otwieramy istniejacy zbior tylko do czytania
//                 ddf_file - bez rozszerzenia .ddf lub z rozszerzeniem
bool iddf::open (const string& ddf_file)
{if (status!=err_uninit) close ();
 ddffile (ddf_file);
 openmode=0; //ios_base::in|ios_base::binary; // tak otwieramy zbiory zawierajace probki
 ifstream inp ((file+ext).c_str(),ios_base::in|ios_base::binary);
//cout<<"Open : <"<<file+ext<<'>'<<'\n';
 if (!inp) status=err_ddf_open;
 else
 {char c[ddf_size_id]; //cout<<"Otwarty\n";
  if (!inp.read(c,ddf_size_id)) status=err_ddf_read_id;
  else
  {string s(c,ddf_size_id);
   if (s==ddf_type_id[1]) status=err_ddf_notimpl; // bz2
    else if (s!=ddf_type_id[0]) status=err_ddf_wrong_id;
     else init (inp); //init (lcb,cb);
  }
 }
//cout<<"Status : "<<status<<' '<<err_ddf_open<<' '<<err_ddf_file<<'\n';
 return status==err_ok;
}
//---------------------------------------------------------------------------
//                 otwieramy istniejacy zbior tylko do czytania ze strumienia
//                 buf - tekstowy, ostatni znak buf to 0
bool iddf::open (const string& ddf_file, const char* const buf)
{if (status!=err_uninit) close ();
 ddffile (ddf_file);
 istringstream inp(buf);
 openmode=0;
 if (!inp) status=err_ddf_open;
 else
 {char c[ddf_size_id];
  if (!inp.read(c,ddf_size_id)) status=err_ddf_read_id;
  else
  {string s(c,ddf_size_id);
   if (s==ddf_type_id[1]) status=err_ddf_notimpl; // bz2
    else if (s!=ddf_type_id[0]) status=err_ddf_wrong_id;
     else init (inp);
  }
 }
 return status==err_ok;
}
//---------------------------------------------------------------------------
void iddf::clear_chans ()
{for (int i=int(chans.size())-1; i>=0; --i) delete chans[i];
 chans.clear ();
 status=err_uninit;
}
void iddf::close ()
{clear_chans ();
}
void iddf::init ()
{status=err_part_init;   // czesciowa inicjalizacja
 n=0;                    // ilosc probek
 ver=100;                // wersja
 comment="";             // komentarz do zbioru
 stm.set ("1 jan 2000 0:0:0"); // poczatek zapisu
 //stm=0;                  // poczatek zapisu  // zly konstruktor ???
 sai=1000000;            // krok probkowania
 site="";                // miejscowosc
 latitude="";            // szerokosc
 longitude="";           // dlugosc
 height="";              // wysokosc
}
void iddf::init (istream& inp)
{init ();             // podstawiamy wartosci domyslne
 int k=0;             // tyle kanalow
 string sfile;
 val<int> val_n(n,"length"),val_k(k,"channels"),val_ver(ver,"version");
 val<string> val_file(sfile,"file"),val_comment(comment,"comment*"),
             val_site(site,"site"),val_lat(latitude,"latitude"),
             val_lon(longitude,"longitude"),val_hei(height,"height");
 val<date> val_date(stm,"date");
 val<DT::time> val_sai(sai,"sampling");
 basic_val* tv[]={&val_n,&val_k,&val_ver,&val_file,&val_date,&val_comment,
                   &val_sai,&val_lat,&val_lon,&val_hei,&val_site};
 const int ltv=sizeof(tv)/sizeof(tv[0]);
//cout<<"Init : "<<file<<' '<<strpath(file)<<'\n';
 string path=strpath(file);
 int r=0;
 do
 {switch (rds(inp))
  {case 'i': r=rdkey(ltv,tv,inp); break; // 0 - ok
   case 'c':
    {chan* pch=new chan(inp,path,openmode);
     if (pch->Status()>0) r=-1;
     if (r==0) chans.push_back (pch); else delete pch;
    }
    break;
   case ' ': r=1; break;   // koniec danych
   case 0: r=-1; break;    // blad
   default:                // nieznana sekcja, opuscic ?
    {
    }
    break;
  }
 }while (r==0);
//cout<<sfile<<' '<<strfile(sfile)<<' '<<file;
 if (r!=1) status=err_ddf_reading_info;
 else if (strfile(file)!=sfile) status=err_ddf_file; // brak zgodnosci nazw zbiorow
 else if (sai==0) status=err_ddf_sampling;
 else
 {n=0; k=int(chans.size());
  for (int i=0; i<k; ++i) n=max(chans[i]->Length(),n);
  status=err_ok;
 }
// cout<<' '<<status<<'\n';
}
char iddf::rds (istream& inp)
{char s=0,c=0; while (inp.get(c) && isspace(c)) {}
 if (c=='[')
 {while (inp.get(c) && isspace(c)) {}
  if (inp)    // c - identyfikator sekcji, pierwszy znak po '['
  {char d=c; while (d!=']' && inp.get(d)) ;
  if (d==']') s=(c==']'?' ':tolower(c));
  }
 }
 return s;  // 0 - blad, ' ' - koniec sekcji, pozostale to identyfikator
}
//---------------------------------------------------------------------------
//             '[' - konczy czytanie
//             key - jest alfanumeryczny
//           r : 0 - czytanie zakonczone na '['
//              -1 - blad czytania (!inp)
//              -2 - brakuje '{'
//              -3 - nie ma takiego klucza
//              -4 - blad set
//
int iddf::rdkey (const int ltv, basic_val* tv[], istream& inp)
{int r=0;
 while (r==0 && inp>>ws && inp.peek()!=eos)
 {string key; char c;
  while (inp.get(c) && isalnum(c)) key+=c;
  if (inp && c=='*') {key+=c; c=' ';}
  while (inp && isspace(c)) inp.get (c);
  if (!inp) r=-1; else if (c!=lpar) r=-2;
  else
  {int i=0; while (i<ltv && tv[i]->key()!=key) ++i;
//   if (i==ltv) r=-3; else if (!tv[i]->set(inp,rpar)) r=-4;
   if (i==ltv) r=-3; else if (!(inp>>*tv[i])) r=-4;
//   cout<<key; if (i<ltv) cout<<'{'<<tv[i]->get()<<'}'; if (r!=0) cout<<' '<<r; cout<<'\n';
  }
 }
// if (r==0) inp.get();  // wczytujemy eos ('[')
 return r;
}
//---------------------------------------------------------------------------
//                 otwieramy istniejacy zbior do czytania i do pisania
//                 ddf_file - bez rozszerzenia .ddf lub z rozszerzeniem
bool ddf::open (const string& ddf_file)
{if (status!=err_uninit) close ();
 ddffile (ddf_file);
 openmode=1; //ios_base::in|ios_base::out|ios_base::binary;  // nie do konca dobrze
 //                bo "open existing file for reading and writing"
 //                wiec gdy ktorys z kanalow ma dlugosc 0 i odpowiadajacy zbior
 //                nie istnieje to otwarcie nie powiedzie sie, dlatego
 //                w tym przypadku trzeba najpierw utworzyc zbior dlugosci zero
 //                nalezy zatem otorzyc z openmode jak wyzej, a jak sie nie powiedzie
 //                to jeszcze raz otworzyc z openmode|ios_base::trunc
 ifstream inp ((file+".ddf").c_str(),ios_base::in|ios_base::binary);
 if (!inp) status=err_ddf_open;
 else
 {char c[ddf_size_id];
  if (!inp.read(c,ddf_size_id)) status=err_ddf_read_id;
  else
  {string s(c,ddf_size_id);
   if (s==ddf_type_id[1]) status=err_ddf_readonly; // bz2 tylko do czytania
    else if (s!=ddf_type_id[0]) status=err_ddf_wrong_id;
     else iddf::init (inp);
  }
 }
 return status==err_ok;
}
//                 tworzymy nowy zbior do czytania i do pisania
//                 jesli istnieje to go ucinamy do 0
//                 ddf_file - bez rozszerzenia .ddf
bool ddf::create (const string& ddf_file)
{if (status!=err_uninit) close ();
 openmode=2; //ios_base::in|ios_base::out|ios_base::trunc|ios_base::binary;
 iddf::init ();   // czesciowa inicjalizacja wartosciami domyslnymi
 file=ddf_file;
 status=err_ok;
                  // poprawka 5.2.2017, sprawdzamy możliwość utworzenia
 {ofstream out(file+".ddf",ios_base::out|ios_base::binary);
  if (!out) status=err_ddf_create;
 }
                  // trzeba upewnic sie ze zbior ddf_file nie istnieje
 return status==err_ok;
}
//                 tworzymy nieistniejacy zbior do czytania i do pisania
//                 parametry kopiujemy ze zbioru iddf_file
//                 ddf_file, iddf_file - bez rozszerzenia .ddf
bool ddf::create (const string& ddf_file, const string& iddf_file, const bool copy_chans)
{iddf idf(iddf_file);
 if (idf.Status()==err_ok) create (ddf_file,idf,copy_chans);
 return status==err_ok;
}
//                          uzywamy w ddf::create
void iddf::init (const string& ddf_file, const iddf& idf, const bool copy_chans)
{n=idf.n;                 // ilosc probek
 ver=idf.ver;             // wersja
 comment=idf.comment;     // komentarz do zbioru
 stm=idf.stm;             // poczatek zapisu
 sai=idf.sai;             // krok probkowania
 site=idf.site;
 latitude=idf.latitude;
 longitude=idf.longitude;
 height=idf.height;
 file=ddf_file;
 if (copy_chans)
 {const int k=int(idf.chans.size());
  for (int i=0; i<k; ++i) chans.push_back (new chan(file,*idf.chans[i],openmode));
 }
 status=err_ok;
}
//                 tworzymy nieistniejacy zbior do czytania i do pisania
//                 parametry kopiujemy ze idf
//                 ddf_file - bez rozszerzenia .ddf
bool ddf::create (const string& ddf_file, const iddf& idf, const bool copy_chans)
{if (status!=err_uninit) close ();
 openmode=2;
 if (idf.Status()<=0 && status==err_uninit) iddf::init (ddf_file,idf,copy_chans);
  else status=err_ddf_create;
 return status==err_ok;
}
void chan::wrs (ofstream& out)
{out<<"[channel]\n"
    <<" offset{"<<lu<<"}\n"
    <<" length{"<<l<<"}\n"
    <<" channel{"<<ident<<"}\n"
    <<" name{"<<wrstr(name)<<"}\n"
    <<" unit{"<<wrstr(unit)<<"}\n"
    <<" sensitivity{"<<sens<<"}\n"
    <<" scale{"<<scale<<"}\n"
    <<" base{"<<base<<"}\n"
    <<" rotation{"<<rot<<"}\n"
    <<" delay{"<<delay.get()<<"}\n"
    <<" code{"<<((code>=0 && code<lcod)?cod[code]:"***")<<"}\n"
    <<" comment*{"<<wrstr(comment)<<"}\n"
    <<" file{"<<wrstr(strfile(file))<<"}\n";
 //out<<" {"<<<<"}\n";
}
void ddf::wrs (ofstream& out, const int ddf_type)
{const int k=int(chans.size());
 out<<ddf_type_id[ddf_type]<<"\n[info]\n"
    <<" version{"<<ver<<"}\n"
    <<" date{"<<stm.getstr(6)<<"}\n"
    <<" sampling{"<<sai.get()<<"}\n"
    <<" length{"<<n<<"}\n"
    <<" channels{"<<k<<"}\n"
    <<" site{"<<wrstr(site)<<"}\n"
    <<" latitude{"<<wrstr(latitude)<<"}\n"
    <<" longitude{"<<wrstr(longitude)<<"}\n"
    <<" height{"<<wrstr(height)<<"}\n"
    <<" comment*{"<<wrstr(comment)<<"}\n"
    <<" file{"<<wrstr(strfile(file))<<"}\n";
 for (int i=0; i<k; ++i) chans[i]->wrs (out);     // wypisujemy kanaly
 out<<"[]\n";
}
bool ddf::close (const int ddf_type)
{if (status<=0)               // wypisujemy zbior informacyjny
 {if (ddf_type==ddf_txt)
  {ofstream out ((file+".ddf").c_str(),ios_base::out|ios_base::binary);
   if (!out) status=err_ddf_close;
   else
   {wrs (out,ddf_type);
    clear_chans ();             // usuwamy kanaly
   }
  }else if (ddf_type==ddf_bz2) status=err_ddf_notimpl; // bz2, ???
   else status=err_ddf_wrong_id;
 }
 return status==err_uninit;   // czy prawidlowe zamkniecie
}
chan* ddf::add (const int k, const int code, const int lu)
{chan* pch=nullptr;
 if (status<=0)        // mozna czytac
 {if (lchan(k)>=0) status=-err_chan_channel_exists;
  else
  {pch=new chan(file,k,code,lu,openmode);  // tu nie powinno byc bledow
   chans.push_back (pch);
  }
 }
// cout<<"status : "<<status<<' '<<pch<<'\n';
 return pch;
}
chan* ddf::add (chan* const pc, const int i)
{chan* pch=nullptr;
 if (status<=0)        // mozna czytac
 {if (lchan(i<0?pc->Channel():i)>=0) status=-err_chan_channel_exists;
  else
  {pch=new chan(file,*pc,openmode,i);
   chans.push_back (pch);
  }
 }
 return pch;
}
bool ddf::remove (const int k)
{if (status<=0)        // mozna czytac
 {const int l=lchan(k);
  if (l<0) status=-err_chan_invalid_channel;
  else
  {delete chans[l]; chans.erase (chans.begin()+l);
  }
 }
 return status==0;
}
int ddf::write (const int k, const int n, const Real* const x)
{if (status<=0)
 {const int l=lchan(k);
  status=(l>=0?chans[l]->write(n,x):err_ddf_channel_ident);
 }
 return status;
}
int ddf::rewrite (const int k, const int n, const Real* const x, const int rw_pos)
{if (status<=0)
 {const int l=lchan(k);
  status=(l>=0?chans[l]->rewrite(n,x,rw_pos):err_ddf_channel_ident);
 }
 return status;
}
/*
ios_base::in becomes "r" (open existing file for reading).
ios_base::out or ios_base::out | ios_base::trunc becomes "w" (truncate existing file or create for writing).
ios_base::out | app becomes "a" (open existing file for appending all writes).
ios_base::in | ios_base::out becomes "r+" (open existing file for reading and writing).
ios_base::in | ios_base::out | ios_base::trunc becomes "w+" (truncate existing file or create for reading and writing).
ios_base::in | ios_base::out | ios_base::app becomes "a+" (open existing file for reading and for appending all writes).
If mode & ios_base::binary is nonzero, the function appends b to strmode to open a binary
stream instead of a text stream. It then stores the value returned by fopen in the file
pointer fp. If mode & ios_base::ate is nonzero and the file pointer is not a null pointer,
the function calls fseek(fp, 0, SEEK_END) to position the stream at end of file. If that
positioning operation fails, the function calls close(fp) and stores a null pointer in
the file pointer.
*/
//
// specjalizacja przeniesiona z ddf.h
             // key       tekst czytamy w ten sposob, ze na poczatku i koncu
             //           opuszczamy biale znaki, a w tekscie ich ciag zastepujemy
             //           jedna spacja ' '
             // key*      to czytamy caly tekst do rpar
             // jesli w czytanym tekscie jest rpar to nalezy go podwoic
template<> bool val<string>::set (istream& inp, const char rpar)
{v.clear ();
 if (isast())  // czytamy caly tekst do rpar
 {char c;
  while (inp.get(c) && (c!=rpar || inp.peek()==rpar))
  {v+=c; if (c==rpar) inp.get (c);
  }
 }else // czytamy tekst opuszczajac spacje do rpar
 {char c; bool spd=true;
  while (inp.get(c) && (c!=rpar || inp.peek()==rpar))
  {const bool spc=(isspace(c)!=0);
   if (!(spc && spd)) {v+=(spc?' ':c); spd=spc;} if (c==rpar) inp.get (c);
  }
  if (!v.empty() && spd) v.erase (v.size()-1);  // usuwamy spacje na koncu
 }
 const bool r=!!inp;
 isv=(r?1:-2);
 return r;
}

