#ifndef _INC_DDF
#define _INC_DDF
//---------------------------------------------------------------------------
#include <string>
#include <sstream>
#include <vector>
#include <fstream>
#include "dts.h"
using namespace std;
typedef double Real;
typedef unsigned short uint2;
typedef unsigned int uint4;
typedef unsigned int uint;
typedef float Real4;
//---------------------------------------------------------------------------
//      liczba x jest poprawnie rozpoznawana gdy x<=maxValid lub x>=Undef
namespace UNDEF
{static constexpr float maxValid=1e38f,tUndef=1.5e38f,Undef=2e38f;
 inline bool isUndef (const double& x) {return x>=double(tUndef);}
 inline bool isValid (const double& x) {return x<double(tUndef);}
 inline bool isValid (const double& x, const double& y) {return x<double(tUndef) && y<double(tUndef);}
 inline void setUndef (double& x) {x=double(Undef);}
 inline bool isUndef (const float& x) {return x>=tUndef;}
 inline bool isValid (const float& x) {return x<tUndef;}
 inline bool isValid (const float& x, const float& y) {return x<tUndef && y<tUndef;}
 inline void setUndef (float& x) {x=Undef;}
 inline float undef () {return Undef;}
 inline double getValid (const double& x) {return x<=double(maxValid)?x:double(Undef);}
//
// const float maxValid,tUndef,Undef; // maxValid<tUndef<Undef;
                   // maxValid - maksymalna dopuszczlna wartosc dla probki
                   // tUndef=.5*(maxValid+Undef) - do testowania czy wartosc niezdefiniowana
                   // Undef - ta waroscia zaznaczamy wartosci niezdefiniowane
// float UNDEF::maxValid=1e38f,UNDEF::tUndef=1.5e38f,UNDEF::Undef=2e38f;
}
//---------------------------------------------------------------------------
inline istream& operator >> (istream& ist, DT::date& dt)
{string sdt;
 while (ist && ist.peek()!='}') sdt+=ist.get();
 if (!dt.set(sdt)) ist.clear (ios_base::badbit);
 return ist;
}
inline ostream& operator << (ostream& ost, const DT::date& dt)
{ost<<dt.getstr(6);
 return ost;
}
inline istream& operator >> (istream& ist, DT::time& tm)
{string sdt;
 while (ist && ist.peek()!='}') sdt+=ist.get();
 if (!tm.set(sdt)) ist.clear (ios_base::badbit);
 return ist;
}
inline ostream& operator << (ostream& ost, const DT::time& tm)
{ost<<tm.get();
 return ost;
}
//---------------------------------------------------------------------------
template <class T> istream& operator >> (istream& ist, vector<T>& v)
{int n; ist>>n;
 if (ist && n>=0) v.resize (n);
 for (int i=0; i<n && ist; ++i) ist>>v[i]; //v.at(i);
 return ist;
}
template <class T> ostream& operator << (ostream& ost, vector<T>& v)
{int n=int(v.size()); ost<<n;
 for (int i=0; i<n && ost; ++i) ost<<(i%8==0?'\n':' ')<<v[i];
 return ost;
}
//---------------------------------------------------------------------------
class basic_val
{public:
 basic_val (const char* const ckey) : ky(ckey) {}
 virtual ~basic_val () {}
 const string& key () const {return ky;}
// char last () const {return ky.empty()?' ':ky[ky.size()-1];}
 bool isast () const {return !ky.empty() && ky[ky.size()-1]=='*';}
 virtual bool set (istream& inp, const char rpar)=0;
 virtual const string& get ()=0;
 private:
 const string ky;
};
//---------------------------------------------------------------------------
//            isv : 1 - v wczytane (ok)
//                  0 - v nie wczytane, byly zainicjalizowane (ok)
//                 -1 - v nie wczytane i nie byly zainicjalizowane (blad)
//                 -2 - blad czytania danych (blad)
template <class T> class val : public basic_val
{public:
 val (T& v, const char* const ckey, const int isv=-1)
     : basic_val(ckey), isv(isv), v(v) {}
 operator T& () {return v;}
 void operator = (const T& w) {v=w; isv=1;}
 bool set (istream& inp, const char rpar)
 {inp>>v; char c; while (inp.get(c) && isspace(c)) {}
  const bool r=(inp && c==rpar);
  isv=(r?1:-2);
  return r;
 }
 const string& get ()
 {if (isv>=0)
//  {ostringstream ost; ost<<key()<<'{'<<v<<'}'; ve=ost.str();
  {ostringstream ost; ost<<v; ve=ost.str();
  }else ve.clear ();
  return ve;
 }
// const T& get () const {return T;}
 private:
 int isv;  // iv=1 v-wczytane, iv=-1 blad czytania v,
 T& v;
 string ve;
};
// specjalizacja przeniesiona do ddf.cpp
// bo kazde #include ddf.h  generuje kolejna funkcje i mamy wielokrotna definicje
/*
             // key       tekst czytamy w ten sposob, ze na poczatku i koncu
             //           opuszczamy biale znaki, a w tekscie ich ciag zastepujemy
             //           jedna spacja ' '
             // key*      to czytamy caly tekst do rpar
             // jesli w czytanym tekscie jest rpar to nalezy go podwoic
template<> bool val<string>::set (ifstream& inp, const char rpar)
{v.clear ();
 if (isast())  // czytamy caly tekst do rpar
 {char c;
  while (inp.get(c) && (c!=rpar || inp.peek()==rpar))
  {v+=c; if (c==rpar) inp.get (c);
  }
 }else // czytamy tekst opuszczajac spacje do rpar
 {char c; bool spd=true;
  while (inp.get(c) && (c!=rpar || inp.peek()==rpar))
  {const bool spc=(isspace(c)!=0);
   if (!(spc && spd)) {v+=(spc?' ':c); spd=spc;} if (c==rpar) inp.get (c);
  }
  if (!v.empty() && spd) v.erase (v.size()-1);  // usuwamy spacje na koncu
 }
 const bool r=!!inp;
 isv=(r?1:-2);
 return r;
}
*/
//---------------------------------------------------------------------------
//                     numeracja bledow wspolna dla klas chan, iddf, ddf
//                      status<=0 - ddf dostepny do czytania/pisania
//                      status>0  - byl blad, ktory uniemozliwia czytanie/pisanie
//                      status!=0 - byl blad
//                      jesli uznamy ze blad nie jest fatalny i umozliwia
//                      dalsze czytanie/pisanie to podstawiamy status=-err_ddf_*
class common_errors
{public:
 enum {err_ok=0, err_uninit=1, err_ddf_channel_ident, err_ddf_open,
       err_ddf_read_id, err_ddf_notimpl, err_ddf_wrong_id, err_ddf_readonly,
       err_chan_file_not_opened_yet, err_chan_open, err_chan_reopen,
       err_chan_code, err_chan_read, err_chan_rewrite_begin, err_chan_write,
       err_part_init, err_ddf_create,err_ddf_close, err_ddf_reading_info,
       err_ddf_file, err_ddf_sampling, err_chan_reading_channel,
       err_chan_reading_code, err_chan_channel_exists, err_chan_invalid_channel,
       err_channel_readonly};
/*
 0 err_ok=0,
 1 err_uninit=1,
 2 err_ddf_channel_ident,
 3 err_ddf_open,
 4 err_ddf_read_id,
 5 err_ddf_notimpl,
 6 err_ddf_wrong_id,
 7 err_ddf_readonly,
 8 err_chan_file_not_opened_yet,
 9 err_chan_open,
10 err_chan_reopen,
11 err_chan_code,
12 err_chan_read,
13 err_chan_rewrite_begin,
14 err_chan_write,
15 err_part_init,
16 err_ddf_create,
17 err_ddf_close,
18 err_ddf_reading_info,
19 err_ddf_file,
20 err_ddf_sampling,
21 err_chan_reading_channel,
22 err_chan_reading_code,
23 err_chan_channel_exists,
24 err_chan_invalid_channel,
25 err_channel_readonly
*/

 //static int ifile (const string& s)
 //{const int l=int(s.size()); int i=((l>1 && s[1]==':')?2:0);
 // for (int j=i; j<l; ++j) if (s[j]=='\\') i=j+1;
 // return i;
 //}
 static string strfile (const string& s)
 {const int l=int(s.size()); int i=((l>1 && s[1]==':')?2:0);
  for (int j=i; j<l; ++j) if (s[j]=='\\' || s[j]=='/') i=j+1;
  return i<l?s.substr(i):"";   // warunek niepotrzeby, pusty tekst dopuszczalny ?
 }
 static string strpath (const string& s)
 {const int l=int(s.size()); int i=((l>1 && s[1]==':')?2:0);
  for (int j=i; j<l; ++j) if (s[j]=='\\' || s[j]=='/') i=j+1;
  return i>0?s.substr(0,i):""; // warunek niepotrzeby, pusty tekst dopuszczalny ?
 }
};
//---------------------------------------------------------------------------
//               file - zbior, w ktorym zapisany jest kanal
//               lu,l - ilosc brakujacych probek (na pocztku), ilosc w zbiorze
//              scale - skalowanie, zeby probki nie przekraczly zakresu (bits/bits)
//               sens - czulosc (units/bits)
//              delay - opoznienie kanalu w mikrosekundach
//              ident - id kanalu, numer kanalu
//               name - nazwa kanalu
//               unit - jednostki
//                rot - kat
//            comment - opis, komentarz do kanalu
//                dat - strumien do czytania/pisania
//             status - stan czytania/pisania
//                      status<0 byl blad, ktory uniemozliwia dalsze operacje
//                      status==0 zbior nie zostal jeszcze otwarty
//                      status>0 zbior otwarty, mozna operowac na zbiorze, ostatnia
//                      operacja powiodla lub jesli byl blad to dalsze operacje
//                      sa mozliwe
//           read_pos - od tego miejsca czytamy
//          write_pos - od tego miejsca piszemy
//
//  wykorzystujemy trzy sposoby otwarcia zbioru zawierajacego probki
//    0 - stary zbior tylko do czytania
//    1 - stary zbior do czytania/pisania
//    2 - nowy zbior do czytania/pisania
//  moze sie zdarzyc ze kanal nie ma zadnej probki i wtedy dopuszczamy, ze
//  "stary" zbior, ktory powinien miec dlugosc 0 nie istnieje
//
class chan : public common_errors
{public:
 chan () {init ();}
 chan (istream& inp, const string& path, const int openmode): openmode(openmode)
  {init (inp,path);}
 chan (const string& ddf_file, const chan& ichan, const int openmode, const int i=-1);
 chan (const string& ddf_file, const int k, const int cd, const int u, const int openmode);
 enum {code_u2=0,code_u3,code_u4,code_f4,code_last};
 int open ();
 int open (const int openmode);
 int openr ();
 int openrw ();
 int errase (const int u);
//
//                   dla danych binarnych zapisanych na zbiorze
//
 static const uint tValid[];
// const uint chan::tValid[]={65535u,16777215u,4294967295u};
 static const int lSize[];
// const int chan::lSize[]={2,3,4,4};
 static const double rBase[],wBase[];
// const double chan::rBase[]={32767.,8388607.,2147483647.,0.};
// const double chan::wBase[]={32767.5,8388607.5,2147483647.5,0.};
 template <class T> inline T testValid () {return tValid[code];}
// template <> inline real4 testValid<real4> () {return 1.5e38f;}
 template <class T> inline bool ifValid (const T w) {return w<testValid<T>();}
 template <class T> inline T undef () {return tValid[code];}
// template <> inline real4 undef<real4> () {return 2.e38f;}
 template <class T> inline T getValid (const double& x)
         {T u=undef<T>(); return (x>=0. && x<double(u))?T(x):u;}
// template <> inline real4 getValid<real4> (const double& x)
//         {return x<=1e38f?real4(x):undef<real4>();}
//
template <class Real>
int read (const int n, Real* const x, const int rd_pos)
                        // jesli rd_pos>=0 czytamy od rd_pos
                        // jesli rd_pos<0 to czytamy od read_pos; jesli zbior nie byl
                        // jeszcze otwarty to otwieramy tylko do czytania
                        // read_pos>=0 i moze przekroczyc zakres danych w zbiorze
                        // pozycja w zbiorze jest okreslona przez read_pos-lu
{//if (status==-err_chan_file_not_opened_yet) open (ios_base::in|ios_base::binary);
 if (status<=0)          // mozemy czytac
 {if (status==-err_chan_file_not_opened_yet) {if (l>0) open (); read_pos=0;}
  int m=n; if (rd_pos>=0) read_pos=rd_pos;
  const int ma=min(lu-read_pos,m);
  if (ma>0)                          // sa brakujace dane na poczatku
  {for (int i=0; i<ma; ++i) x[i]=UNDEF::undef();  // poczatkowe brakujace dane
   read_pos+=ma; m-=ma;
  }
  const int mb=min(lu+l-read_pos,m);
  if (mb>0)                          // tyle danych wczytujemy ze zbioru
  {if (status<=0) rea (mb,x+(n-m));  // x+(n-m) - od tego miejsca wczytujemy
   read_pos+=mb; m-=mb;
  }
  if (m>0)
  {for (int i=0; i<m; ++i) x[n-m+i]=UNDEF::undef(); // brakujace dane na koncu
   read_pos+=m;
  }
 }
 return status;
}
 //template <class Real> int write (const int n, const Real* const x);
 //template <class Real> int write (const int n, const Real* const x, const Real* const y);
                        // dopisujemy do konca zbioru, jesli zbior nie byl
                        // jeszcze otwarty to otwieramy do czytania i pisania
template <class Real>
int write (const int n, const Real* const x)
{//if (status==-err_chan_file_not_opened_yet) open (ios_base::in|ios_base::out|ios_base::binary);
 if (status<=0 && n>0)          // mozemy pisac
 {if (status==-err_chan_file_not_opened_yet) open ();
  write_pos=lu+l; if (status<=0) wri (n,x); if (status==err_ok) l+=n;
 }
 return status;
}
                         // jak wyzej tylko roznice x-y
template <class Real>
int write (const int n, const Real* const x, const Real* const y)
{//if (status==-err_chan_file_not_opened_yet) open (ios_base::in|ios_base::out|ios_base::binary);
 if (status<=0 && n>0)          // mozemy pisac
 {if (status==-err_chan_file_not_opened_yet) open ();
  write_pos=lu+l; if (status<=0) wri (n,x,y); if (status==err_ok) l+=n;
 }
 return status;
}
 int rewrite (const int n, const Real* const x, const int rw_pos);
//                             obliczmy zakres x
template <class Real>
bool ext (const int n, const Real* const x, Real& xi, Real& xa)
{int i=0; while (i<n && UNDEF::isUndef(x[i])) ++i;
 if (i<n)
 {Real zi=x[i],za=x[i];
  for (int j=i+1; j<n; ++j)
   {const Real xc=x[j]; if (UNDEF::isValid(xc)) {if (xc<zi) zi=xc; if (xc>za) za=xc;}}
  xi=zi; xa=za;
 }
 return i<n;
}
//                               wyznaczamy optymalna skale i baze
//                               0<=((x[i]-base)/(scale*sens)+wBase[code])<tValid[code]
template <class Real>
void sb (const int n, const Real* const x)
{static double eps=1.e-10;
 base=0; scale=1.;
 if (code<code_f4)      // tylko dla danych calkowitych
 {Real xi,xa;
  if (ext(n,x,xi,xa))   // byly jakies zdefiniowane wartosci
  {const double sc=(double(xa)-double(xi))/double(tValid[code])*(1.+eps);
   //base=double(xi)+wBase[code]*sc;
   base=.5*(double(xi)+double(xa));
   if (sc>0.) scale=sc/sens;
  }
 }
}
//                               wyznaczamy optymalna skale i baze dla x-y
template <class Real>
void sb (const int n, const Real* const x, const Real* const y)
{static double eps=1.e-10;
 base=0; scale=1.;
 if (code<code_f4)   // tylko dla danych calkowitych
 {int i=0; while (i<n && (UNDEF::isUndef(x[i]) || UNDEF::isUndef(y[i]))) ++i;
  if (i<n)
  {Real zi=x[i]-y[i]; Real za=zi;
   for (int j=i+1; j<n; ++j)
   {const Real xc=x[j],yc=y[j];
    if (UNDEF::isValid(xc) && UNDEF::isValid(yc))
     {const Real zc=xc-yc; if (zc<zi) zi=zc; if (zc>za) za=zc;}
   }
   const double sc=(double(za)-double(zi))/double(tValid[code])*(1.+eps);
   //base=double(zi)+wBase[code]*sc;
   base=.5*(double(zi)+double(za));
   if (sc>0.) scale=sc/sens;
  }
 }
}
//                               s, b - skala i baza
//                               r==1 mozna uzyc s i b
//                               r==2 nie mozna bylo zachowac oryginalnej skali s
//                               r==3 nie mozna bylo zachowac oryginalnej bazy b
//                               r==4 nie mozna bylo zachowac ani skali ani bazy
//                               0<=((x[i]-base)/(scale*sens)+wBase[code])<tValid[code]
template <class Real>
int sb (const int n, const Real* const x, const Real& s, const Real& b)
{int r=1;
 base=b; scale=s;
 Real xi,xa;
 if (code<code_f4 && ext (n,x,xi,xa)) // tylko dla danych calkowitych, i sa jakies wartosci
 {double sc=scale*sens;
  double ui=(double(xi)-base)/sc+wBase[code],ua=(double(xa)-base)/sc+wBase[code];
  const double u=double(undef<uint>());
  if (ua-ui>=u)                    // zla skala, xi<xa
  {static double eps=1.e-10;
   sc=(double(xa)-double(xi))/double(tValid[code])*(1.+eps);
   scale=sc/sens;
   ui=(double(xi)-base)/sc+wBase[code]; ua=(double(xa)-base)/sc+wBase[code];  // nowa skala, stara baza
   r=2;
  }
  if (ui<0. || ua>=u)              // zla baza
  {//base=xi+sc*wBase[code];
   //base=xa-sc*(u-wBase[code]);
   //base=.5*(xi+xa)+sc*(wBase[code]-.5*u);
   base=.5*(double(xi)+double(xa));                // wBase[code]==.5*u
   r+=2;
  }
 }
 return r;
}
 int Status () const {return status;}
 const string& Comment () const {return comment;}
 chan& Comment (const string& c) {comment=c; return *this;}
 int Code () const {return code;}
 int Code (const int c) {const int i=code; code=c; return i;}
 double Scale () const {return scale;}
 chan& Scale (const double& s) {scale=s; return *this;}
 double Sensitivity () const {return sens;}
 chan& Sensitivity (const double& s) {sens=s; return *this;}
 double Base () const {return base;}
 chan& Base (const double& s) {base=s; return *this;}
 const string& Name () const {return name;}
 chan& Name (const string& s) {name=s; return *this;}
 const string& Unit () const {return unit;}
 chan& Unit (const string& s) {unit=s; return *this;}
 const DT::time Delay () const {return delay;}
 chan& Delay (const DT::time& s) {delay=s; return *this;}
 double Rotation () const {return rot;}
 chan& Rotation (const double& s) {rot=s; return *this;}
 int Channel () const {return ident;}
 chan& Channel (const int i) {ident=i; return *this;}
 const string& File () const {return file;}
 chan& File (const string& s) {file=s; return *this;}
 int Length () const {return lu+l;}
 int Offset () const {return lu;}
 chan& Offset (const int i) {lu=max(i,0); return *this;}
 void wrs (ofstream& out);
 static const int lcod=5; static const char* cod[lcod];
 static const int lopm=3; static const ios_base::openmode opm[lopm];
// static const int lopm=3; static const int opm[lopm];
// const int lcod=5; const char* cod[lcod]={"u2","u3","u4","f4","txt"};
 private:
 void init ();
 int init (istream& inp, const string& path);
//                 zapisujemy liczby na m=16,24,32 bitach bez znaku
//                 maksymalna wartosc 2^m-1 oznacza niezdefiniowana probke
//                 wartosci zdefiniowane : 0<=u<=2^m-2
//                 -(2^(m-1)-1)<=u-(2^(m-1)-1)<=(2^(m-1)-1)
//                 mamy tyle samo wartosci dodatnich i ujemnych
//                 2^m=65536,16777216,4294967296
//                 2^(m-1)=32768,8388608,2147483648
template <class Real, class T> void Rea (const int n, Real* const x)
{const double und=UNDEF::undef(),sc=scale*sens,b=rBase[code];
 const int size=lSize[code];
 T w=0; const T v=testValid<T>();
 for (int i=0; !!dat && i<n; ++i)
 {dat.read (reinterpret_cast<char*>(&w),size);
  x[i]=Real(w<v?UNDEF::getValid((double(w)-b)*sc+base):und);
 }
}
                                     // czytamy ze zbioru od read_pos
template <class Real> void rea (const int n, Real* const x)
{if (code>=0 && code<code_last)
 {dat.seekg ((read_pos-lu)*lSize[code]);  // pozycja w zbiorze, powinna byc >=0
  if (code<code_f4) Rea<Real,uint> (n,x); else Rea<Real,Real4> (n,x);
  status=(!dat?err_chan_read:err_ok);
 }else status=err_chan_code;
}
template <class Real, class T> void Wri (const int n, const Real* const x)
{const double sc=scale*sens,b=wBase[code];
 const int size=lSize[code]; const T u=undef<T>();
 for (int i=0; !!dat && i<n; ++i)
 {const T w=(UNDEF::isValid(x[i])?getValid<T>((double(x[i])-base)/sc+b):u);
  dat.write (reinterpret_cast<const char*>(&w),size);
 }
}
                                     // piszemy na zbior od write_pos
template <class Real> void wri (const int n, const Real* const x)
{if (code>=0 && code<code_last)
 {dat.seekp ((write_pos-lu)*lSize[code]);  // pozycja w zbiorze, powinna byc >=0
  if (code<code_f4) Wri<Real,uint> (n,x); else Wri<Real,Real4> (n,x);
  status=(!dat?err_chan_write:err_ok);
 }else status=err_chan_code;
}
template <class Real, class T> void Wri (const int n, const Real* const x, const Real* const y)
{const double sc=scale*sens,b=wBase[code];
 const int size=lSize[code]; const T u=undef<T>();
 for (int i=0; !!dat && i<n; ++i)
 {const T w=(UNDEF::isValid(x[i],y[i])?getValid<T>((double(x[i]-y[i])-base)/sc+b):u);
  dat.write (reinterpret_cast<const char*>(&w),size);
 }
}
                                     // piszemy na zbior od write_pos
template <class Real> void wri (const int n, const Real* const x, const Real* const y)
{if (code>=0 && code<code_last)
 {dat.seekp ((write_pos-lu)*lSize[code]);  // pozycja w zbiorze, powinna byc >=0
  if (code<code_f4) Wri<Real,uint> (n,x,y); else Wri<Real,Real4> (n,x,y);
  status=(!dat?err_chan_write:err_ok);
 }else status=err_chan_code;
}
 void wri (const int n);
 string file;
 int code;
 int lu,l;
 double scale,sens,base;
 DT::time delay;
 int ident;
 string name,unit;
 double rot;
 string comment;
 fstream dat;
 int status;
 int openmode;
 int read_pos,write_pos;

};
//   specjalizacja musi byc poza klasa
template <> inline Real4 chan::testValid<Real4> () {return 1.5e38f;}
template <> inline Real4 chan::undef<Real4> () {return 2.e38f;}
template <> inline Real4 chan::getValid<Real4> (const double& x)
//         {return x<=1e38f?Real4(x):undef<Real4>();}
         {const auto x4=Real4(x); return x4<=1e38f?x4:undef<Real4>();}
//---------------------------------------------------------------------------
                          // mozna tylko czytac istniejacy zbior ddf
class iddf : public common_errors
{public:
 iddf () : status(err_uninit) {}
 iddf (const string& ddf_file) : status(err_uninit) {open (ddf_file);}
 iddf (const string& ddf_file, const char* const buf) : status(err_uninit) {open (ddf_file,buf);}
 ~iddf () {close ();}
 int Status () const {return status;}
 bool open (const string& ddf_file);
 bool open (const string& ddf_file, const char* const buf);
 void close ();
template <class Real>
int read (const int k, const int n, Real* const x, const int rd_pos=-1)
{if (status<=0)        // mozna czytac
 {const int l=lchan(k);
  status=(l>=0?chans[l]->read(n,x,rd_pos):err_ddf_channel_ident);
 }
 return status;
}
 const string& File () const {return file;}
 const string& Comment () const {return comment;}
 const string& Site () const {return site;}
 const string& Latitude () const {return latitude;}
 const string& Longitude () const {return longitude;}
 const string& Height () const {return height;}
 DT::date Date () const {return stm;}
 DT::date EDate () const {return stm+(n-1)*sai;}
 DT::time Sampling () const {return sai;}
 double Dt () const {return double(sai)/1000000.;}
 int Length () const {return n;}
 int Channels () const {return int(chans.size());}
 int Channel (const int i) const {return ((i>=0 && i<int(chans.size()))?chans[i]->Channel():0);}
 chan* Chan (const int i) const {return ((i>=0 && i<int(chans.size()))?chans[i]:nullptr);}
                    // zwraca wskaznik do kanalu o danym numerze
 bool Chan (const int i, chan*& ch)
 {const int j=lchan(i); if (j>=0) ch=chans[j];
  return j>=0;
 }
 static int rdkey (const int ltv, basic_val* tv[], istream& inp);
 static const char lpar='{',rpar='}',eos='[';
 protected:
 void clear_chans ();
 void init ();
 void init (istream& inp);
 void init (const string& ddf_file, const iddf& idf, const bool copy_chans);
 enum {ddf_size_id=8,ddf_txt=0,ddf_bz2=1};
 char rds (istream& inp);
 int lchan (const int k) const
  {int l=int(chans.size()); while (--l>=0 && chans[l]->Channel()!=k) {} return l;}
 void ddffile (const string& ddf_file);
 int status;
 int openmode;      // sposob otwarcia kanalu
 string file;
 static string ddf_type_id[2];
// int filetype;
 int n;             // ilosc probek
 int ver;           // wersja
 string comment;    // komentarz do zbioru
 vector<chan*> chans;
 DT::date stm;      // poczatek zapisu
 DT::time sai;      // krok probkowania
 string site;
 string latitude,longitude,height;
 static const char* const ext;
 private:
};
//---------------------------------------------------------------------------
class ddf : public iddf
{public:
 ddf () {}
 ddf (const string& ddf_file) {create (ddf_file);}
 ddf (const string& ddf_file, const string& iddf_file, const bool copy_chans=true)
  {create (ddf_file,iddf_file,copy_chans);}
 ddf (const string& ddf_file, const iddf& iddf_iddf, const bool copy_chans=true)
  {create (ddf_file,iddf_iddf,copy_chans);}
 ~ddf () {close (ddf_txt); clear_chans ();}
 bool open (const string& ddf_file);
 bool create (const string& ddf_file);
 bool create (const string& ddf_file, const string& iddf_file, const bool copy_chans);
 bool create (const string& ddf_file, const iddf& idf, const bool copy_chans);
 bool close (const int ddf_type=ddf_txt);
 chan* add (const int k, const int code, const int lu=0);
 chan* add (chan* const pc, const int i=-1);
 bool remove (const int k);
 int write (const int k, const int n, const Real* const x);
 int rewrite (const int k, const int n, const Real* const x, const int rw_pos);
 ddf& Comment (const string& c) {comment=c; return *this;}
 ddf& Site (const string& c) {site=c; return *this;}
 ddf& Latitude (const string& c) {latitude=c; return *this;}
 ddf& Longitude (const string& c) {longitude=c; return *this;}
 ddf& Height (const string& c) {height=c; return *this;}
 ddf& Date (const DT::date& s) {stm=s; return *this;}
 ddf& Sampling (const DT::time& s) {sai=s; return *this;}
 ddf& Dt (const double dt) {sai=int8(dt*1000000.+5); return *this;}
 ddf& Length (const int l) {n=l; return *this;}
 DT::time Sampling () const {return sai;}
 DT::date Date () const {return stm;}
 private:
 void wrs (ofstream& out, const int ddf_type);
};
//---------------------------------------------------------------------------
#endif
