#include "dts.h"
#include <iomanip>
#include <sstream>
using namespace std;
//---------------------------------------------------------------------------
namespace DT
{
 static const char* mon[]={"Jan","Feb","Mar","Apr","May","Jun",
                           "Jul","Aug","Sep","Oct","Nov","Dec"};

 int ird (int& i, const char* const c, const bool skipws=false);
 int frd (int& i, const char* const c);
//---------------------------------------------------------------------------
     //        format stm : 10d 5h 3m 4.5s
     //        kazdy ze skladnikow moze wystepowac w dowolnej kolejnosci,
     //        ilosci i zakresie poniewaz jest sumowany;
     //        przyrostek 's' jest domyslny;
     //        czesc po kropce jest zaokraglana do mikrosekund
 bool time::set (const string& stm)
 {const int l=int(stm.size()),idg=ldg+1;
  char d[ltm]={'s','m','h','d'};
  int s[ltm]={1,60,3600,86400};
  int8 uds=0;
  bool r=false;
  int k=0;
  do
  {while (k<l && stm[k]==' ') ++k;    // opuszczamy spacje
   if (k<l)                          // cos jest
   {int kp=k,v=0,vd=-1; while (k<l && isdigit(stm[k])) v=v*10+(stm[k++]-'0');
    int ndg=k-kp;                    // tyle cyfr przed ewentualna kropka
    if (k<l && stm[k]=='.')           // jest czesc ulamkowa
    {vd=0; int dg=0;
     while (++k<l && isdigit(stm[k])) if (dg<idg) {vd=vd*10+(stm[k]-'0'); ++dg;}
     ndg+=dg;                        // tyle wszystkich cyfr
     while (dg<idg) {++dg; vd*=10;}
     vd=(vd+5)/10;
    }
    r=(ndg>0);                        // byla liczba
    if (r)                            // jest liczba
    {char c='s';                      // domyslnie sekundy
     while (k<l && stm[k]==' ') ++k;   // opuszczamy spacje
     if (k<l && !isdigit(stm[k])) c=stm[k++]; // jednostka
     int i=0; while (i<ltm && c!=d[i]) ++i;
     r=(i<ltm);
     if (r)                           // jednostka znaleziona
     {uds+=(v*int8(s[i]))*1000000;
      if (c=='s' && vd>=0) uds+=vd;   // sa mikrosekundy
      r=(c=='s' || vd<0);             // ulamek tylko z sekundami
     }
    }
   }
  }while (r && k<l);
  tm=(r?uds:0);
  return r;
 }
     // zamieniamy czas tm na format : 10d 5h 3m 4.5s
 string time::get () const
 {const int lt=4; int nt[lt+1];
  const int mt[lt]={1000000,60,60,24};
  const char c[lt]={'d','h','m','s'};
  int8 u=tm;
  string s;
  if (u==0) s="0s";
  else
  {char cp=0;
   if (u<0) {s+='-'; cp=' '; u=-u;}  // na wszelki wypadek
   for (int i=0; i<lt; ++i) {nt[i]=int(u%mt[i]); u/=mt[i];} nt[lt]=int(u);
   for (int i=0; i<lt; ++i) if (nt[lt-i]!=0)
   {if (cp!=0) {s+=cp; s+=' ';}
    int v=nt[lt-i]; string sd; do {sd+=char(v%10+'0'); v/=10;} while (v>0);
    for (int j=int(sd.size())-1; j>=0; --j) {s+=sd[j];} cp=c[i];
   }
   if (nt[0]>0)                      // mikrosekundy
   {if (cp!=0 && cp!='s') {s+=cp; s+=' ';} s+='.'; cp='s';
    int w=mt[0]/10,v=nt[0]; while (v%10==0) {v/=10; w/=10;}
    do {s+=char(v/w+'0'); v%=w; w/=10;} while (w>0);
   }
   s+=cp;
  }
  return s;
 }
     // zamieniamy cas tm na : days hours:minutes:seconds.sss
     // dg - tyle cyfr z mikrosekundami, zaokraglamy czas
 string time::rgetstr (const int dg) const
 {const int8 usr=tm+int8((dg>=0 && dg<ldg)?rnd[dg]:0);     // zaokraglamy
  int s=int(usr%int8(60000000)),m=int(usr/int8(60000000));
  const int u=s%1000000;          // usekundy
  s/=1000000;                     // sekundy
  const int h=m/60;               // w godzinach
  m%=60;                          // minuty
  ostringstream ost;
  ost<<h/24<<' '<<h%24<<':'<<m<<':'<<s;
  if (dg>0)
  {const int d=(dg<=ldg?dg:ldg);           // 1 - 6
   ost<<'.'<<setfill('0')<<setw(d)<<u/pwd[d-1];
  }
  return ost.str();
 }
//---------------------------------------------------------------------------
     // wczytujemy liczbe bez znaku, ewentualnie opuszczamy spacje na poczatku
 int ird (int& i, const char* const c, const bool skipws)
 {if (skipws) while (isspace(c[i])) ++i;
  int v=0,j=i; while (isdigit(c[i])) v=v*10+(c[i++]-'0');
  if (i==j) v=-1;  // nie bylo zadnej cyfry
  return v;
 }
     // wczytujemy czesc ulamkowa, c[i]=='.' (nie sprawdzamy)
 int frd (int& i, const char* const c)
 {const int idg=ldg+1;     // zaokraglamy do ldg cyfr
  int vd=0,dg=0;
  while (isdigit(c[++i])) if (dg<idg) {vd=vd*10+(c[i]-'0'); ++dg;}
  while (dg<idg) {++dg; vd*=10;}
  return (vd+5)/10;
 }
     // zamieniamy day.month.year hour:minute:second.sss na tablice liczb ndt
 bool setDate (int ndt[ldt], const char* const sdt)
 {int i=0; ndt[0]=ird(i,sdt,true);  // dzien
  bool r=((sdt[i]=='.' || sdt[i]==' ') && ndt[0]>0 && ndt[0]<32);
  if (r)
  {if (sdt[i]=='.')                 // 19.3.2000
   {ndt[1]=ird(++i,sdt);
    r=(sdt[i]=='.' && ndt[1]>0 && ndt[1]<13); if (r) ndt[2]=ird(++i,sdt);
   }else                           // 19 Mar 2000
   {while (sdt[++i]==' ') {}       // opuszczamy spacje
    int j=0,k;
    do
    {k=0; while (k<3 && toupper(mon[j][k])==toupper(sdt[i+k])) ++k;
    }while (k<3 && ++j<12);
    r=(j<12); if (r) {ndt[1]=j+1; i+=3; ndt[2]=ird(i,sdt,true);}
   }
   if (r) r=(ndt[2]>=0);
   if (r)
   {r=false;
    ndt[3]=ird(i,sdt,true);         // godzna
    if (sdt[i]==':' && ndt[3]>=0 && ndt[3]<24)
    {ndt[4]=ird(++i,sdt);           // minuta
     if (sdt[i]==':' && ndt[4]>=0 && ndt[4]<60)
     {ndt[5]=ird(++i,sdt);          // sekunda
      if (ndt[5]>=0 && ndt[5]<60)
      {ndt[6]=(sdt[i]=='.'?frd(i,sdt):0);
       while (isspace(sdt[i])) ++i;
       r=(sdt[i]==0);
      }
     }
    }
   }
  }
  return r;
 }
         // ilosc dni w miesiacu danego roku
         // (9*m+9)/16-(9*m)/16 == ((9*m)%16+8)/16
         // (m+14)/16-(m+13)/16 == (16-(m+14)%16)/16
 int lMonth (const int month, const int year)
 {const int y=year+(month-1)/12,m=(month-1)%12+1;
  //static const int mo[]={31,28,31,30,31,30,31,31,30,31,30,31};
  //return mo[(month-1)%12]+(4-y%4)/4-(100-y%100)/100+(400-y%400)/400;
  //return 30+(9*m+9)/16-(9*m)/16-(m+14)/16+(m+13)/16
  //       -(y%4+3)/4+(y%100+99)/100-(y%400+399)/400;
  //return (489*m+489)/16-(489*m)/16-(m+14)/16+(m+13)/16
  //       -(y%4+3)/4+(y%100+99)/100-(y%400+399)/400;
  //return (489*m+489)/16-(489*m)/16-(m+14)/16+(m+13)/16
  //       -(y%4+3)/4-(100-y%100)/100+(400-y%400)/400;
  return (489*m+489)/16-(489*m)/16-(m+14)/16+(m+13)/16
       +(month==2?-(y%4+3)/4-(100-y%100)/100+(400-y%400)/400:0);
 }
        // zamieniamy day, month, year na numer dnia w roku liczony od 1
 int relDay (const int day, const int month, const int year)
 {const int b=(month+13)/16; const int a=year+b;
  return day-b*(1+(year%4+3)/4)-(3*((a+99)/100))/4+(489*month)/16-30
         +(3*((year+99)/100))/4;
  //return day-b-(3*a)/4-(3*((a+99)/100))/4+(489*month)/16-30
  //       +(3*year)/4+(3*((year+99)/100))/4;
 }
         // odwrotnie do relDay, zamieniamy numeracje dnia w roku na day, month
         // rday - numer dnia w roku year liczony od 1
         // day, month - dzien, miesiac w roku year
 void dmDate (const int rday, const int year, int& day, int& month)
 {int iy=(4-year%4)/4-(100-year%100)/100+(400-year%400)/400;
  int id=(rday+305)%(365+iy);         // nr dnia w roku liczony od 1 marca (od zera)
  int a=id+id+60*(id/153);
  int b=a/61;
  day=(a%61)/2+1;
  month=(b-b/6+2)%12+1;
 }
         // zamieniamy day, month, year na dzien liczony
         // od 1 marca 0 roku, absolutna numeracje dni zaczynamy od zera
         // (489*month)/16 == (275*month)/9
         // (month+9)/12 == (month+13)/16
 int absDay (const int day, const int month, const int year)
 {const int base=-91;   // dzien 0 odpowiada 1 marca 0 roku
  const int b=(month+13)/16; const int a=year+b;
//  return 366*year+day-b-(3*a)/4-(3*((a+99)/100))/4+(489*month)/16+base;
  return 365*year+day-2*b+(a+3)/4-(3*((a+99)/100))/4+(489*month)/16+base;
 }
         // wykorzystujemy pierwsze 3 elementy tablicy ndt
         // zamieniamy day, month, year z tablicy ndt na dzien liczony
         // od 1 marca 0 roku, absolutna numeracje dni zaczynamy od zera
 int absDay (const int ndt[ldt])
 {const int base=-91;   // dzien 0 odpowiada 1 marca 0 roku
  int b=(ndt[1]+9)/12;
  int a=ndt[2]+b;
  int c=ndt[0]-b-(3*a)/4-(3*((a+99)/100))/4+(275*ndt[1])/9+base;
  return 366*ndt[2]+c;
 }
         // wyznaczamy pierwsze 3 elementy tablicy ndt
         // odwrotnie do absDay, zamieniamy absolutna numeracje dni
         // na day, month, year i wpisujemy do tablicy ndt
 void dmyDate (int ndt[ldt], const int absday)
 {int q=(absday%146097)/36524;        // 0<=q<=4
  int d1=absday+(absday/146097)*3+q-q/4;
  q=(d1%1461)/365; q-=q/4;            // 0<=q<4
  int y=(d1/1461)*4+q;                // rok-1 liczony od 1 marca
  int id=d1%1461-q*365;               // nr dnia w roku
  ndt[2]=y+id/306;                    // rok
  int a=id+id+60*(id/153);
  int b=a/61;
  ndt[0]=(a%61)/2+1;
  ndt[1]=(b-b/6+2)%12+1;
 }
     // zamieniamy tablice liczb ndt na : day.month.year hour:minute:second.sss
     // dg - tyle cyfr z mikrosekundami
 string getDate (const int ndt[ldt], const int dg)
 {ostringstream s;
  s<<setfill('0')<<setw(2)<<ndt[0]<<'.'<<setw(2)<<ndt[1]<<'.'<<setw(4)<<ndt[2]<<' '
   <<setw(2)<<ndt[3]<<':'<<setw(2)<<ndt[4]<<':'<<setw(2)<<ndt[5];
  if (dg>0)
  {int d=(dg<=ldg?dg:ldg);           // 1 - 6
   s<<'.'<<setw(d)<<ndt[6]/pwd[d-1];
  }
  return s.str();
 }
//---------------------------------------------------------------------------
 bool date::set (const string& sdt)
 {int ndt[ldt];
  if (DT::setDate(ndt,sdt.c_str())) setnc (ndt); else dt=undefined_date;
  return good();
 }
 void date::setnc (const int ndt[ldt])
 {dt=int8(ndt[6]+1000000*ndt[5])+int8(60000000)*int8((absDay(ndt)*24+ndt[3])*60+ndt[4]);
 }
 void date::getnc (int ndt[ldt]) const
 {int a=int(dt%int8(60000000)),b=int(dt/int8(60000000));
  ndt[6]=a%1000000; ndt[5]=a/1000000;
  ndt[4]=b%60; b/=60;
  ndt[3]=b%24; dmyDate (ndt,b/24);
 }
 bool date::get (string& sdt, const int dg)
 {if (good()) {int ndt[ldt]; getnc (ndt); sdt=DT::getDate(ndt,dg);}
  return good();
 }
 string date::getstr (const int dg) const
 {int ndt[ldt];
  return get(ndt)?DT::getDate(ndt,dg):"";
 }
 bool date::rget (string& sdt, const int dg)
 {int ndt[ldt];
  if (good())
  {//(dg>=0 && dg<ldg)?date(dt+rnd[dg]).getnc(ndt):getnc(ndt);
   ((dg>=0 && dg<ldg)?date(dt+rnd[dg]):*this).getnc(ndt);
   sdt=DT::getDate(ndt,dg);
  }
  return good();
 }
 string date::rgetstr (const int dg)
 {int ndt[ldt];
  if (good()) ((dg>=0 && dg<ldg)?date(dt+rnd[dg]):*this).getnc(ndt);
  return good()?DT::getDate(ndt,dg):"";
 }
}
//---------------------------------------------------------------------------
/*
#include <iostream>
#include <iomanip>
using namespace DT;
void date_test ()
{int8 it8=0;
 string sdt("");
 DT::time tma,tmb;
// date tb(it8);
 date dta,dtb,dtc(sdt);
// date td=ta-tb;
// DT::time tmc=dta-dtb;
// ta+tb;
 if (!!dta) {cout<<"+ta\n";} else {cout<<"-ta\n";}
 if (!dta) {cout<<"-ta\n";} else {cout<<"+ta\n";}
 if (dtc.good()) {cout<<"+tc\n";} else {cout<<"-tc\n";}
 if (!dtc) {cout<<"-tc\n";} else {cout<<"+tc\n";}
 int it=1;
 dta+=it8;
 dta+=it;
 dta+=3;
 dta+=tma;
 dta=dtb+it8;
 dta=dtb+it;
 dta=dtb+3;
 dta=dtb+tma;
// ta=3+tb;
// ta+=tb;
// ta+=3.;
// ta=tb+tc;
 cout<<sizeof(dta)<<' '<<sizeof(tma)<<'\n';
}
*/
