#ifndef _INC_DT
#define _INC_DT
//---------------------------------------------------------------------------
#include <string>
using namespace std;
//---------------------------------------------------------------------------
//typedef long long int8;
typedef int64_t int8;     // 64 - bity
                          // przyrost czasu (mikrosekundy)
//---------------------------------------------------------------------------
namespace DT
{   //  format stm - 10d 5h 3m 4.5s
    //      ltm==4 - z tylu liczb sklada sie czas
    //  format sdt - 19.03.2000 18:30:52.16430 lub 19 Mar 2000 18:30:52.16430
    //      ldt==7 - z tylu liczb sklada sie data i czas
    //      ldg==6 - czesc ulamkowa sekund w mikrosekundach
    //       
 enum {ltm=4,ldt=7,ldg=6};
//---------------------------------------------------------------------------
 class time
 {public:
  time () : tm(0) {}
  explicit time (const string& stm) {set(stm);}
  time (const int8& itm) {tm=itm;}
  explicit time (const double& t) {tm=int8(t*1000000.+.5);}
  bool set (const string& stm);
  string get () const;
//  string rget (const int dg);
  string rgetstr (const int dg) const;
//  operator double () const {return double(tm)/1000000.;}
  operator int8 () const {return tm;}
  private:
  int8 tm;
 };
//---------------------------------------------------------------------------
 static const int rnd[ldg]={500000,50000,5000,500,50,5},    // zaokraglanie
                  pwd[ldg]={100000,10000,1000,100,10,1};    // potegi 10
// przesuniete do dts.cpp
// static const char* mon[]={"Jan","Feb","Mar","Apr","May","Jun",
//                           "Jul","Aug","Sep","Oct","Nov","Dec"};
    // zamieniamy day.month.year hour:minute:second.ssssss 
    //        lub   day Mon year hour:minute:second.ssssss  na tablice liczb ndt
 bool setDate (int ndt[ldt], const char* const sdt);
         // ilosc dni w miesiacu danego roku
 int lMonth (const int month, const int year);
         // zamieniamy day, month, year na numer dnia w roku liczony od 1
 int relDay (const int day, const int month, const int year);
         // odwrotnie do relDay, zamieniamy numeracje dnia w roku na day, month
         // rday - numer dnia w roku year liczony od 1
         // day, month - dzien, miesiac w roku year
 void dmDate (const int rday, const int year, int& day, int& month);
         // zamieniamy day, month, year na dzien liczony
         // od 1 marca 0 roku, absolutna numeracje dni zaczynamy od zera
 int absDay (const int day, const int month, const int year);
         // wykorzystujemy pierwsze 3 elementy tablicy ndt
         // zamieniamy day, month, year z tablicy ndt na dzien liczony
         // od 1 marca 0 roku, absolutna numeracje dni zaczynamy od zera
 int absDay (const int ndt[ldt]);
         // wyznaczamy pierwsze 3 elementy tablicy ndt
         // odwrotnie do absDay, zamieniamy absolutna numeracje dni
         // na day, month, year i wpisujemy do tablicy ndt
 void dmyDate (int ndt[ldt], const int absday);
     // zamieniamy tablice liczb ndt na : day.month.year hour:minute:second.sss
     // dg - tyle cyfr z mikrosekundami
 string getDate (const int ndt[ldt], const int dg);
//---------------------------------------------------------------------------
 //static const int8 undefined_date=0x8000000000000000; // czas niezdefiniowany
 static const int8 undefined_date=-1; // czas niezdefiniowany
 class date
 {public:
  date () : dt(undefined_date) {}
  date (const date& dte) : dt(dte.dt) {}
  const date& operator = (const date& dte) {dt=dte.dt; return *this;}
  explicit date (const string& sdt) {set (sdt);}
  date (const int ndt[ldt]) {set (ndt);}
  bool set (const string& sdt);
  bool set (const int ndt[ldt]) {setnc (ndt); return good();} // powinno sie sprawdzic
  bool get (int ndt[ldt]) const {if (good()) getnc (ndt); return good();}
  bool get (string& sdt, const int dg);
  string getstr (const int dg) const;
  bool rget (string& sdt, const int dg);
  string rgetstr (const int dg);
//  date round (const int dg) {return date((good() && dg>=0 && dg<ldg)?dt+rnd[dg]:dt);}
  time operator - (const date& dtr) const {return dt-dtr.dt;}
// int8 operator - (const date& tr) const {return t-tr.t;}

  date operator - (const time& tm) const {return date(dt-int8(tm));}
  date operator + (const time& tm) const {return date(dt+int8(tm));}
  const date& operator -= (const time& tm) {dt-=int8(tm); return *this;}
  const date& operator += (const time& tm) {dt+=int8(tm); return *this;}

  date operator - (const int8& itm) const {return date(dt-itm);}
  date operator + (const int8& itm) const {return date(dt+itm);}
  const date& operator -= (const int8& itm) {dt-=itm; return *this;}
  const date& operator += (const int8& itm) {dt+=itm; return *this;}

  date operator - (const int itm) const {return date(dt-itm);}
  date operator + (const int itm) const {return date(dt+itm);}
  const date& operator -= (const int itm) {dt-=itm; return *this;}
  const date& operator += (const int itm) {dt+=itm; return *this;}

  date operator - (const double& rtm) const {return date(dt-int8(rtm*1000000.+.5));}
  date operator + (const double& rtm) const {return date(dt+int8(rtm*1000000.+.5));}
  const date& operator -= (const double& rtm) {dt-=int8(rtm*1000000.+.5); return *this;}
  const date& operator += (const double& rtm) {dt+=int8(rtm*1000000.+.5); return *this;}

// operator bool () const {return t>=0;}
  bool good () const {return dt>undefined_date;}
  bool bad () const {return dt<=undefined_date;}
  bool operator ! () const {return dt<=undefined_date;}
  bool operator != (const date& dtr) const {return dt!=dtr.dt;}
  bool operator == (const date& dtr) const {return dt==dtr.dt;}
  bool operator <  (const date& dtr) const {return dt< dtr.dt;}
  bool operator <= (const date& dtr) const {return dt<=dtr.dt;}
  bool operator >  (const date& dtr) const {return dt> dtr.dt;}
  bool operator >= (const date& dtr) const {return dt>=dtr.dt;}
  date round (const time& tm) const {return date(dt-dt%tm);}
  date near (const time& tm) const {int8 r=dt%tm; if (r+r>=tm) r-=tm; return date(dt-r);}
  int8 mod (const time& tm) const {return dt%tm;}
//   
// dt=j*idt+dt%idt, 0 <= dt%idt < idt
// rdt - na siatce idt najbliższy do dt
// udt - na siatce ndc*idt (również na siatce idt), udt >= rdt
// udt=rdt+i*idt
// dokładny czas udt to udt+r
  pair<date,int> resampl (const time& idt, const int ndc) const
  {auto r=dt%idt; if (r+r>=idt) r-=idt;
   const auto rdt=dt-r;
   const auto udt=((rdt-1)/(ndc*idt)+1)*(ndc*idt);
   const int i=(udt-rdt)/idt;     // udt jest również na siatce idt
   return {date(rdt),i};
  }
  private:
  explicit date (const int8& idt) {dt=idt;}
  void set (const int8& idt) {dt=idt;}
  void getnc (int ndt[ldt]) const;                  // bez sprawdzania
  void setnc (const int ndt[ldt]);            // bez sprawdzania
  int8 get () const {return dt;}
//  bool rget (int ndt[ldt], const int dg);
  int8 dt;
 };
}
//void date_test ();
//---------------------------------------------------------------------------
#endif
