// g++ -Wall -Wextra -pedantic-errors -O3 lb3ddf_1s.cpp ddf.cpp dts.cpp -o lb3ddf_1s -Wno-misleading-indentation
//---------------------------------------------------------------------------
#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <sstream>
#include <cmath>
#include <vector>
#include <array>
#include <algorithm>
#include <map>
#include "color.hpp"
#include "dts.h"
#include "ddf.h"
//------------------------------------------------------------------------------
using namespace std;
using Real=double;
//------------------------------------------------------------------------------
template < typename T >
std::string Info(T s1, T s2, T s3)
{
  std::stringstream sss("");
  sss<<"------------------------------------------\nlb3ddf_1s, v. "<<s1<<", (C) IGF PAN\n"<<"Last modification: "<<s2<<"\nAuthor: "<<s3;
  sss<<"\n------------------------------------------";
  return sss.str();
}
template <typename T> T convert_to (const std::string &str)
{
    std::istringstream ss(str);
    T num;
    ss >> num;
    return num;
}
template < typename T >
std::string NTS(T data)
{
  std::stringstream sstr("");
  sstr << data;
  return sstr.str();
}
bool isDigit (string s)
{
  for (size_t n = 0; n < s.length(); n++)
    {
      if (!isdigit( s[ n ] ))
       {
         return false;
       }
    }
  return true;
}
//------------------------------------------------------------------------------
struct Sampl{long long t; array<Real,6> v;};
//------------------------------------------------------------------------------
struct cha{string name,unit; Real sca;};
//--------------------------------------------------------------------------------
const string LastModDate = "2026-01-02";
const string ProgVersion = "1.1";
const string Author = "nemar@igf.edu.pl & kn@igf.edu.pl";
//--------------------------------------------------------------------------------
int main (const int argc, const char* const argv[])
{
 auto pinfo = color::rize( Info(ProgVersion,LastModDate,Author), "Blue", "Default","Bold", "All" ); cout<<pinfo<<'\n';
 if (argc!=6) 
   {
     auto PrgInfo = color::rize("Usage:\nlb3ddf_1s /home/nemar/part.csv /home/nemar/LB772 /home/nemar/long_772.csv /home/nemar/dt.log 4\n", "Blue", "Default","Bold", "All" ); cout<<PrgInfo;
     cerr<<"  where: \n"
           "  /home/nemar/part.csv - latest CSV file\n"
           "  /home/nemar/LB772 - output DDF file\n"
           "  /home/nemar/long_772.csv - output long CSVfile\n"
           "  /home/nemar/dt.log - DT of last sample (from LB-480 logger)\n"
           "  4 - number of channels to write into DDF\n";
     exit (0);
    }
 string PartCsv=argv[1];
 string LongCsv=argv[3];
 string DTlog=argv[4];
 string str_Ch=argv[5];
 
 auto mes = color::rize( "Append long csv file -> "+LongCsv, "Light Yellow", "Blue", "Default" ); cout<<mes<<'\n'; 
 string Lcsv; int sret=0;
 Lcsv="cat "+PartCsv+" >> "+LongCsv;
 sret = system(Lcsv.c_str());
 if (sret!=0){std::cout<<"Something wrong -> "<<Lcsv<<endl;}
 
 if(!isDigit(str_Ch)){auto err = color::rize("Error, the number of channels must be a number! Exit ...", "Black", "Light Red", "Default" ); cout<<err<<'\n'; exit(0);}
 const int k = convert_to <int>(str_Ch);
 if (k<=0 || k>6) {cerr<<"Error. Not correct number of channels [1-6]!\n"; return 0;}
 vector<Real> v(k);
 vector<vector<Real>> dat(k); vector<DT::date> t;
 {
  ifstream csv(argv[1]);
  std::cout<<"Reading CSV -> "<<argv[1]<<"\nPlease wait...\n";
  string s,c(6,0),d(2,0); char G;
  int l=0;
  while (getline(csv,s))
  {++l;
   int yea,mon,day,hou,min,sec; Real msec;
   istringstream ist(s);
   ist>>yea>>c[0]>>mon>>c[1]>>day>>c[2]>>hou>>c[3]>>min>>c[4]>>sec>>msec>>c[5]>>G;
   if (!ist || c!="--T::,") {cerr<<"Time reading error! Line: "<<l<<'\n'; return 0;}
   //   cerr<<c<<"  "<<yea<<' '<<mon<<' '<<day<<"  "<<hou<<' '<<min<<' '<<sec<<' '<<int(1000*msec+.5)<<'\n';
   if (G=='G')                // tylko próbki z gps
   {for (int j=0; j<k; ++j)   // kolejna kolumna
    {ist>>d[0]>>v[j]>>d[1];
     if (!ist || d!=",V") {cerr<<"Data reading error! Line: "<<l<<'\n'; return 0;}
     dat[j].push_back (v[j]);
    }
    t.push_back (array<int,DT::ldt>{day,mon,yea,hou,min,sec,int(1000000*msec+.5)}.data());
   }
  }
  
  //cerr<<dat[0].size()<<'\n'; 
  const int n=t.size();
  
  if (n<8) {cerr<<"Error. Not enought data!\n"; return 0;}
  // Only 1s data
  const DT::time odt("1s");
  DT::date sdt,edt;
  sdt=t[0]; edt=t[n-1];
  cout<<"DT range of CSV file -> "<<sdt.getstr(3)<<" --- "<<edt.getstr(3)<<'\n';
  cerr<<"The number of samples: "<<t.size()<<'\n';
  int Sdt[7]; int Edt[7];
  DT::setDate (Sdt, sdt.getstr(3).c_str()); 
  DT::setDate (Edt, edt.getstr(3).c_str());
  const int BYear = Sdt[2]; const int EYear = Edt[2];
  //cerr<<"Sy:"<<<<",  Ey:"<<Edt[2]<<endl;
  ddf oddf;
  ddf oddf2;
  const string ddfPath=argv[2];
  const string ddfFile=ddfPath+"_"+NTS(BYear);
  if (!oddf.open(ddfFile)) {cerr<<"Can not open output file file : "<<oddf.File()<<'\n'; exit (0);}
  std::cout<<"DDF for update -> "<<ddfFile<<"\n";
  const DT::date sd=oddf.Date(),ed=oddf.EDate();
  //cout<<"Output ddf DT range => From: "<<sd.getstr(3)<<" to "<<ed.getstr(3)<<'\n';
  DT::date sdn; DT::date edn;
  if((EYear-BYear)==1)
   {
     const string ddfFile2=ddfPath+"_"+NTS(EYear);
     if (!oddf2.open(ddfFile2)) {cerr<<"Can not open output file file : "<<oddf2.File()<<'\n'; exit (0);}
     std::cout<<"DDF for update -> "<<ddfFile2<<"\n";
     sdn=oddf2.Date(); edn=oddf2.EDate();
     //cout<<"Output ddf DT range => From: "<<sdn.getstr(3)<<" to "<<edn.getstr(3)<<'\n';
   }
  if((EYear-BYear)>1){cerr<<"DT range of CSV file is more than 1 year. \nPlease check CSV file. \nExit ... "<<'\n'; exit (0);}
  if((EYear-BYear)<0){cerr<<"Not correct CSV file. \nExit ... "<<'\n'; exit (0);}
  // Update DDF(s)
  Real* const x=new Real[1];
  for (int j=0; j<n; j++) 
    {
      const DT::date smt(t[j]);
      if (smt>=sd && smt<=ed)
        {
          const int mps=int((smt-sd)/odt);
          for (int cc=0; cc<k; cc++) {x[0]=dat[cc][j]; oddf.rewrite (cc+1, 1, x, mps);}
         }
     if ((EYear-BYear)==1 && smt>=sdn && smt<=edn)
        {
          const int mps=int((smt-sdn)/odt);
          for (int cc=0; cc<k; cc++) {x[0]=dat[cc][j]; oddf2.rewrite (cc+1, 1, x, mps);}
         }
     }
  delete [] x;
  //dat[i][j] t[j]
  mes = color::rize( "Update log DT file -> "+DTlog, "Light Yellow", "Blue", "Default" ); cout<<mes<<'\n'; 
  ofstream flog (argv[4], ios::out); if (!flog){cout<<"\n Can't open DT log file "<<argv[4]; exit(0);}
  flog<<edt.getstr(3)<<'\n';
  flog.close();
 }
 return 0;
}
//------------------------------------------------------------------------------
